/**
* \file: FSAuthenticator.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2015 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_FS_AUTHENTICATOR_H
#define AAUTO_FS_AUTHENTICATOR_H

#include <string.h>
#include <aauto/GalReceiver.h>
#include <aauto/util/shared_ptr.h>

namespace adit { namespace aauto {

class FSAuthenticator
{
public:
    FSAuthenticator();
    ~FSAuthenticator();

    /**
     * @brief Sets the raw data developers certificates.
     *
     * @param receiver Pointer to the GalReceiver.
     *
     * @return true on success, false on failure
     * */
    bool setCertificates(shared_ptr<GalReceiver> receiver);

    /**
     * @brief Sets the configuration parameters
     *        to keep the interface identical for authentication mechanisms
     *
     * @param inKey Key name.
     *        "rootCertificate" for path to the root certificate
     *        "clientCertificate" for path to the client certificate
     *        "privateKey" for path to the private key
     *
     * @param inValue Key value for the associated key name.
     * */
    void setConfigItem(std::string inKey, std::string inValue);

private:

    /**
     * Map for configuration parameters:
     *  - Path to root certificate
     *  - Path to cleint certificate
     *  - Path to private key
     */
    std::map<std::string, std::string> config;

    /**
     * @brief Gets an item, returns false if item does not exist.
     *
     * @param [in] key Key name of the item
     * @param [out] result Value of the item
     *
     * @return bool true: if available, false: if not available
     */
    bool getConfigItem(const std::string& inKey, std::string& outResult);

    /**
     * @brief Returns unwrapped root certificate.
     *
     * @return Root certificate as raw data.
     *         Empty string means error.
     * */
    std::string getRootCert();

    /**
     * @brief Returns unwrapped client certificate.
     *
     * @return Client certificate as raw data.
     *         Empty string means error.
     * */
    std::string getClientCert();

    /**
     * @brief Returns unwrapped private key.
     *
     * @return Private key as raw data.
     *         Empty string means error.
     * */
    std::string getPrivateKey();

    std::string pullFromFileSystem(const std::string& inFileName);
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_FS_AUTHENTICATOR_H */

